/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.QuickReferenceWriter;

public class QuickReferenceWriterTest
extends TestCase {
    private ByteArrayOutputStream actualBuffer;
    private ByteArrayOutputStream expectedBuffer;
    private PrintStream expected;
    private QuickReferenceWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.actualBuffer = new ByteArrayOutputStream();
        this.writer = new QuickReferenceWriter(new PrintStream(this.actualBuffer));
        this.expectedBuffer = new ByteArrayOutputStream();
        this.expected = new PrintStream(this.expectedBuffer);
    }

    public void testWritesSimplifiedSummaryOfMatchers() throws IOException {
        FactoryMethod namedMethod = new FactoryMethod("SomeClass", "someMethod", "unusedReturnType");
        namedMethod.addParameter("Cheese", "a");
        namedMethod.addParameter("int", "b");
        namedMethod.setGenerifiedType("String");
        this.writer.writeMethod("namedMethod", namedMethod);
        FactoryMethod anotherMethod = new FactoryMethod("SomeClass", "anotherMethod", "unusedReturnType");
        anotherMethod.setGenerifiedType("int");
        this.writer.writeMethod("anotherMethod", anotherMethod);
        this.expected.println("        [String] namedMethod(Cheese a, int b)");
        this.expected.println("           [int] anotherMethod()");
        this.verify();
    }

    public void testRemovesPackageNames() throws IOException {
        FactoryMethod namedMethod = new FactoryMethod("SomeClass", "someMethod", "unusedReturnType");
        namedMethod.addParameter("com.blah.Foo", "a");
        namedMethod.addParameter("com.foo.Cheese<x.y.Zoo>", "b");
        namedMethod.setGenerifiedType("java.lang.Cheese");
        this.writer.writeMethod("namedMethod", namedMethod);
        this.expected.println("        [Cheese] namedMethod(Foo a, Cheese<Zoo> b)");
        this.verify();
    }

    private void verify() {
        QuickReferenceWriterTest.assertEquals((String)new String(this.expectedBuffer.toByteArray()), (String)new String(this.actualBuffer.toByteArray()));
    }
}

